#Kruskal Wallis test biomass of prey differ between carnivores
#starting
setwd("~/Desktop/Tuli thesis/Statistics")
getwd()

#for repeatability, setting a seed to initialize a pseudo-random number generator. 
set.seed(1234)

DataKW <- read.csv (file = "KruskalWallisKG.csv")

head(DataKW)
levels(DataKW$group)

library("ggpubr")
ggboxplot(DataKW, x = "group", y = "weight", 
          color = "group", palette = c("#00AFBB", "#E7B800", "#FC4E07", "#3ebb00"),
          order = c("leopard", "spotted", "brown", "wild"),
          ylab = "Weight consumed prey in kilograms", xlab = "Predators")

kruskal.test(weight ~ group, data = DataKW)

